//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Tuples
//:
//: Functions can return multiple values in a "tuple".
//:
//: A tuple should be treated as a variable and can be passed around in code as any other variable can. The difference being only the sub variables exposed by index or by label.
//:
//: Execute the run point below. The function returns a tuple containing 2 string values.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func generateATuple() -> (String, String) {
    ("first value", "second value")
}
let tuple = generateATuple()
let string1 = tuple.0
let string2 = tuple.1


//:
//: -------------------
//:
//: Tuples are not restricted to two values.
//:
//: Execute the run point below. The code returns a tuple containing 5 strings.
//:
//: -------------------
//:


func generateAnotherTuple() -> (String, String, String, String, String) {
    ("first value", "second value", "third value", "fourth value", "fifth value")
}
let tuple2 = generateAnotherTuple()
let string3 = tuple2.0
let string4 = tuple2.1
let string5 = tuple2.3
let string6 = tuple2.4


//:
//: -------------------
//:
//: A tuple may define labels to retrieve each value for increased clarity.
//:
//: -------------------
//:


func generateAThidTuple() -> (label1: String, label2: String) {
    ("first value", "second value")
}
let tuple3 = generateAThidTuple()
var string7 = tuple3.0
var string8 = tuple3.1

string7 = tuple3.label1
string8 = tuple3.label2


//:
//: -------------------
//:
//: Execute the run point below. 
//:
//: The code represents a real-life example of a useful algorithm.
//:
//: A function accepts a full name as input then returns the first and last names separated and put together in a tuple.
//:
//: returning them in a tuple. Labels were used to better identify each value.
//:
//: -------------------
//:


import Foundation // imports code for components(separatedBy:)
func readName(_ name: String) -> (first: String, last: String) {
    let names = name.components(separatedBy: " ")
    if
    let firstName = names.first, // unwrap optional if value exists
    let lastName = names.last {  // unwrap another optional
        return (first: firstName, last: lastName)
    }
    return ("", "") // no names found
}
let names = readName("Steve Jobs")
let firstName = names.first
let lastName = names.last
print(firstName, lastName)



//:
//: -------------------
//:
/*:
  * Callout(Tip 💡):
    Did you notice the `import` in the code above?
 
    Apple created many frameworks (packages of code) to enhance the language and interact with thier custom-made systems. Each framework is available within Xcode and importing them allows us to use them in our code.
 */
//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a function to accept one string as input.
//:
//: The input string should be instantiated with this format; `"firstName lastName age"`.
//:
//: In the function separate out each value and store all 3 in a tuple to be returned from the function.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: Execute the code below.
//:
//: The function accepts a string that hopefully contains the format `"firstName lastName age"`. It then extracts out each entered value and returns a more usable tuple with labeled properties.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


extension Array {
    subscript (safe index: Int) -> Element? {
        (index >= 0 && index < count) ? self[index] : nil
    }
}

func readProfile(_ personalDetails: String) -> (first: String?, last: String?, age: Int?) {
    let profile = personalDetails.components(separatedBy: " ")
    var tuple: (String?, String?, Int?) = (nil, nil, nil)
    if
    let firstName = profile[safe: 0],
    let lastName = profile[safe: 1] {
        tuple.0 = firstName
        tuple.1 = lastName
        if let stringAge = profile[safe: 2] {
            let age: Int? = Int(stringAge)
            tuple.2 = age
        }
    }
    return tuple
}
let profile = readProfile("Steve Jobs 52")
print(profile.first ?? "", profile.last ?? "", profile.age ?? "")


//:
//: -------------------
//:
//: ## Task:
//:
//: Edit the code below.
//:
//: Add a fourth entry to the tuple returned, which will contain the phone number if one was entered.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func readProfileValues(_ personalDetails: String) -> (first: String?, last: String?, age: Int?) {
    let profile = personalDetails.components(separatedBy: " ")
    var tuple: (String?, String?, Int?) = (nil, nil, nil)
    if
    let firstName = profile[safe: 0],
    let lastName = profile[safe: 1] {
        tuple.0 = firstName
        tuple.1 = lastName
        if let stringAge = profile[safe: 2] {
            let age: Int? = Int(stringAge)
            tuple.2 = age
        }
    }
    return tuple
}
let profile2 = readProfileValues("Steve Jobs 52")
print(profile2.first ?? "", profile2.last ?? "", profile2.age ?? "")


//:
//:
//: -------------------
//:
//: ## Task:
//:
//: Write a function to return a tuple containing 10 numbers.
//:
//: Each number should range from `1` to `10` i.e. `(1,2,3,4,5,6,7,8,9,10)`.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here








